.\" This file is public domain.
.\" Originally written 1995, Geoffrey Tobin.
.\" The author has expressed the hope that any modification will
.\" retain enough content to remain useful.  He would also appreciate being
.\" acknowledged as the original author in the documentation.
.\" This declaration added 2008/11/14 by Clea F. Rees with the
.\" permission of Geoffrey Tobin.
.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe and Geoffrey R. D. Tobin",
.\"     version         = "0.6.0",
.\"     date            = "08 March 1995",
.\"     time            = "19:57:00 GMT +11",
.\"     filename        = "dt2dv.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "03708 156 634 4989",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "DVI, TeX",
.\"     supported       = "no",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the dt2dv utility, a program for
.\"                        converting a DTL text representation of a TeX
.\"                        DVI file, usually produced by the companion
.\"                        dv2dt utility, back to a binary DVI file.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH DT2DV 1 "08 March 1995" "Version 0.6.0"
.\"======================================================================
.SH NAME
dt2dv \- convert a DTL text representation of a TeX DVI file to a binary DVI file
.\"======================================================================
.SH SYNOPSIS
.B dt2dv
.RB [ \-debug ]
.RB [ \-group ]
.RB [ \-si ]
.RB [ \-so ]
.RI [ input-DTL-file ]
.RI [ output-DVI-file ]
.PP
In the absence of the
.B \-si
and
.B \-so
options,
both file arguments are
.I required
in the order
.BR "input-DTL-file output-DVI-file" .
But also see the OPTIONS section below.
No default file extensions are supplied.
.\"======================================================================
.SH DESCRIPTION
.B dt2dv
converts a text representation of a \*(Te\& DVI
file, usually produced by the companion
.BR dv2dt (1)
utility, back to a binary DVI file.
DTL
.RI ( "DVI Text Language" )
files can be edited, with care, and then restored
to DVI form for processing by any \*(Te\& DVI
driver program.  In DTL files, font directory names
and font names are preceded by a length field,
which must be updated if the names are modified.
.PP
.BR dvitype (1)
can also display a textual representation of DVI
files, but in some implementations at least, it
cannot be used in batch mode, and its output is
not well-suited for conversion back to a DVI file.
.PP
The format of \*(Te\& DVI files is fully described
in
Donald E.\& Knuth,
.IR "\*(Te\&: The Program" ,
Addison-Wesley (1986), ISBN 0-201-13437-3, as well
as in the
.BR dvitype (1)
literate program source code.  Brief descriptions
of the DTL and DVI formats are given in
.BR dv2dt (1).
.\"======================================================================
.SH OPTIONS
.\"-----------------------------------------------
.TP \w'\-debug'u+3n
.B \-debug
Turn on detailed debugging output.
.\"-----------------------------------------------
.TP
.B \-group
Expect each DTL command to be in parentheses.
.\"-----------------------------------------------
.TP
.B \-si
Read all DTL commands from standard input.
.\"-----------------------------------------------
.TP
.B \-so
Write all DVI commands to standard output.
.\"======================================================================
.SH "SEE ALSO"
.BR dv2dt (1),
.BR dvitype (1),
.BR tex (1).
.\"======================================================================
.SH FILES
.TP \w'\fI*.dvi\fP'u+3n
.I *.dvi
binary \*(Te\& DVI file.
.TP
.I *.dtl
text representation of a \*(Te\& DVI file in
.I "DVI Text Language"
format.
.\"======================================================================
.SH AUTHOR
.B dt2dv
and
.BR dv2dt (1)
were written by
.RS
.nf
Geoffrey Tobin
Department of Electronic Engineering
La Trobe University
Bundoora, Victoria 3083
Australia
Tel: +61 3 479 3736
FAX: +61 3 479 3025
Email: <G.Tobin@ee.latrobe.edu.au>
.fi
.RE
.PP
These manual pages were written primarily by
.RS
.nf
Nelson H.\& F.\& Beebe, Ph.D.
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: <beebe@math.utah.edu>
.fi
.RE
.\"==============================[The End]==============================
