-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2012  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Globals; use Globals;

package Attachments is

   type Attachment_List is limited private;

   Attachment_Not_Found : exception;

   -- Add an attachment to the list....
   procedure Add_Attachment (Filename  : in     UBS;
                             List      : in out Attachment_List);

   -- Remove an attachment.  We then shuffle the array down.
   -- It will only remove the last attachment if there are multiple instances.
   procedure Remove_Attachment (Filename  : in     UBS;
                                List      : in out Attachment_List);

   -- List the attachments and edit them as appropriate (include removing an
   -- attachment or adding a new one.
   procedure List (List : in out Attachment_List);

   procedure Empty_Attachment_List (List : in out Attachment_List);

   function Count (List : in Attachment_List) return Natural;

   -- This function takes the original Tmpfile, and (in the case of a
   --  non-empty attachment list) replaces it with a multipart/mixed
   --  structure.  The attachments in List are base64 armoured.  We
   --  assume that Tmpfile has already been appropriately
   --  processed....  This is safe to call if List is empty.
   procedure Replace_Tmpfile (Tmpfile           : in String;
                              List              : in Attachment_List);

private

   type Attachment_List is
      record
         AA    : UVV;
      end record;

end Attachments;
