% tpm2_policysigned(1) tpm2-tools | General Commands Manual

# NAME

**tpm2_policysigned**(1) - Enables policy authorization by verifying signature
of optional TPM2 parameters. The signature is generated by a signing authority.

# SYNOPSIS

**tpm2_policysigned** [*OPTIONS*]

# DESCRIPTION

**tpm2_policysigned**(1) - Enables policy authorization by verifying signature
of optional TPM2 parameters. The signature is generated by a signing authority.
The optional TPM2 parameters being cpHashA, nonceTPM, policyRef and expiration.

# OPTIONS

  * **-L**, **\--policy**=_FILE_:

    File to save the compounded policy digest.

  * **-S**, **\--session**=_FILE_:

    The policy session file generated via the **-S** option to
    **tpm2_startauthsession**(1).

  * **-c**, **\--key-context**=_OBJECT_:

    Context object for the key context used for the operation. Either a file
    or a handle number. See section "Context Object Format".

  * **-g**, **\--hash-algorithm**=_ALGORITHM_:

    The hash algorithm used to digest the message.

  * **-s**, **\--signature**=_FILE_:

    The input signature file of the signature to be validated.

  * **-f**, **\--format**=_FORMAT_:

    Set the input signature file to a specified format. The default is the
    tpm2.0 TPMT_SIGNATURE data format, however different schemes can be selected
    if the data came from an external source like OpenSSL. The tool currently
    supports rsassa and ecdsa.

  * **-t**, **\--expiration**=_NATURAL_NUMBER_:

    Set the expiration time of the policy in seconds. In absence of nonceTPM
    the expiration time is the policy timeout value. If expiration is a negative
    value an authorization ticket is additionally returned. If expiration value
    is 0 then the policy does not have a time limit on the authorization.

  * **\--ticket**=_FILE_:

    The ticket file to record the authorization ticket structure.

  * **\--timeout**=_FILE_:

    The file path to record the timeout structure returned.

  * **-q**, **\--qualification**=_FILE\_OR\_HEX\_STR_:

    Optional, the policy qualifier data that the signer can choose to include in the
    signature. Can be either a hex string or path.

  * **-x**, **\--nonce-tpm**:

    Enable the comparison of the current session's nonceTPM to ensure the
    validity of the policy authorization is limited to the current session.

## References

[common options](common/options.md) collection of common options that provide
information many users may expect.

[common tcti options](common/tcti.md) collection of options used to configure
the various known TCTI modules.

# EXAMPLES

Authorize a TPM operation on an object whose authorization is bound to specific
signing authority.

## Create the signing authority
```bash
openssl genrsa -out private.pem 2048

openssl rsa -in private.pem -outform PEM -pubout -out public.pem
```

## Generate signature with nonceTPM, cpHashA, policyRef and expiration set to 0
```bash
echo "00 00 00 00" | xxd -r -p | \
openssl dgst -sha256 -sign private.pem -out signature.dat
```

## Load the verification key and Create the policysigned policy
```bash
tpm2_loadexternal -C o -G rsa -u public.pem -c signing_key.ctx

tpm2_startauthsession -S session.ctx

tpm2_policysigned -S session.ctx -g sha256 -s signature.dat -f rsassa \
-c signing_key.ctx -L policy.signed

tpm2_flushcontext session.ctx
```

## Create a sealing object to use the policysigned
```bash
echo "plaintext" > secret.data

tpm2_createprimary -C o -c prim.ctx

tpm2_create -u key.pub -r sealing_key.priv -c sealing_key.ctx -C prim.ctx \
-i secret.data -L policy.signed
```

## Satisfy the policy and unseal secret
```bash
tpm2_startauthsession -S session.ctx --policy-session

tpm2_policysigned -S session.ctx -g sha256 -s signature.dat -f rsassa \
-c signing_key.ctx -L policy.signed

tpm2_unseal -p session:session.ctx -c sealing_key.ctx

tpm2_flushcontext session.ctx
```

[returns](common/returns.md)

[limitations](common/policy-limitations.md)

[footer](common/footer.md)
