// @HEADER
// ************************************************************************
//
//               Rapid Optimization Library (ROL) Package
//                 Copyright (2014) Sandia Corporation
//
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact lead developers:
//              Drew Kouri   (dpkouri@sandia.gov) and
//              Denis Ridzal (dridzal@sandia.gov)
//
// ************************************************************************
// @HEADER

#ifndef ROL_SACADO_STDINEQUALITYCONSTRAINT_HPP
#define ROL_SACADO_STDINEQUALITYCONSTRAINT_HPP

#include "ROL_Sacado_StdEqualityConstraint.hpp"
#include "ROL_InequalityConstraint.hpp"

namespace ROL {

template<class Real, template<class> class Constr>
class Sacado_StdInequalityConstraint : public Sacado_StdEqualityConstraint<Real,Constr>,
                                       public InequalityConstraint<Real> {

  typedef Sacado_StdEqualityConstraint<Real,Constr> SEC;
  typedef Vector<Real>     V;

public:

  using EqualityConstraint<Real>::value;
  void value(V &c, const V &x, Real &tol ) {
    SEC::value(c,x,tol);
  }

  using EqualityConstraint<Real>::applyJacobian;
  void applyJacobian(V &jv, const V &v, const V &x, Real &tol) {
    SEC::applyJacobian(jv, v, x, tol);
  }

  using EqualityConstraint<Real>::applyAdjointJacobian;
  void applyAdjointJacobian(V &aju, const V &u, const V &x, Real &tol) {
    SEC::applyAdjointJacobian(aju, u, x, tol);
  }

  using EqualityConstraint<Real>::applyAdjointHessian;
  void applyAdjointHessian(V &ahuv, const V &u, const V &v, const V &x, Real &tol) {
    SEC::applyAdjointHessian(ahuv, u, v, x, tol);
  } 

}; // class Sacado_StdInequalityConstraint
 
} // namespace ROL 

#endif // ROL_SACADO_STDINEQUALITYCONSTRAINT_HPP

