#!/bin/bash

# Copyright © 2009 Stefano Zacchiroli <zack@debian.org>
# License: GNU GPL version 3 or above
# Created:       Mon, 20 Jul 2009 12:42:04 +0200
# Last-Modified: Mon, 20 Jul 2009 12:42:04 +0200

PKG="turbogears2-doc"

SVN_URL="$1"
if [ -z "$SVN_URL" ] ; then
    echo "Usage: $0 SVN_URL"
    exit 1
fi

svn_tmp=$(mktemp -d --tmpdir=. svn-tmp.XXXXXXXXXX)
trap "rm -rf $svn_tmp" EXIT

echo "Checking out sources from SVN $SVN_URL ..."
svn co -q "$SVN_URL" "$svn_tmp/svn"
svn_rev=$(svn info $svn_tmp/svn | grep 'Revision:' | cut -f 2 -d' ')
orig_name="${PKG}_2.0+svn${svn_rev}.orig.tar.gz"
svn export "$svn_tmp/svn" "$svn_tmp/$PKG"
echo "Creating upstream tarball ..."
(cd "$svn_tmp" && tar czf $orig_name $PKG)
mv $svn_tmp/$orig_name .
echo "All done."
