/*
 * twpsk:  A basic ham loging program using Motif
 * Copyright (C) 1999->2014 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Version: 4.3 - Aug 2017
 */

/*
 * Globals for help find
 */

#include "GUI.h"
#include "twpskHelp.h"
#include "helpText.h"

#if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
extern Pixmap pixmap;
#endif

char pattern[41];  /* pattern for help find */
Widget helpTxt, helpDiag, findAgnPB, topicLabel;
int sec;
char *found;

/*
 * popupHelp Function
 * Created the first time it is called and then managed as needed.  
 * Use the button number to index to the right help section.
 * Set for modeless so main interface is still active.
 */

void Help::popupHelp (int topicNum)
{
   int i;
   XmString xs;
   Arg args[20];

   if (helpDiag == NULL)
   {
      helpDiag = XmCreateFormDialog(shell, (char *)"helpDiag", NULL, 0);

      XtVaSetValues (helpDiag,
         XmNdialogStyle, XmDIALOG_MODELESS,
         NULL);

      XtVaSetValues (XtParent(helpDiag),
      XmNtitle, WIN_TITLE,       /* set title bar */
      #if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
      XmNiconPixmap, pixmap,
      #endif
      NULL);

      topicLabel = XtVaCreateManagedWidget ("topicLabel", xmLabelWidgetClass,
         helpDiag,
         XmNtopAttachment, XmATTACH_FORM,
         XmNleftAttachment, XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_NONE,
         XmNrightAttachment, XmATTACH_FORM,
         NULL);        

      pbform = XtVaCreateWidget ("pbform", xmFormWidgetClass, helpDiag,
         XmNwidth, 500,
         XmNtopAttachment, XmATTACH_NONE,
         XmNleftAttachment, XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNrightAttachment, XmATTACH_FORM,
         NULL);

      findPB = XtVaCreateManagedWidget ("Find", xmPushButtonWidgetClass, pbform,
         XmNwidth, PBWIDTH,
         XmNtopAttachment, XmATTACH_FORM,
         XmNtopOffset, 10,
         XmNleftAttachment, XmATTACH_POSITION,
         XmNleftPosition, 10,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNbottomOffset, 10,
         XmNrightAttachment, XmATTACH_POSITION,
         XmNrightPosition, 20,
         NULL);

      findAgnPB = XtVaCreateManagedWidget ("Find Again",
         xmPushButtonWidgetClass, pbform,
         XmNsensitive, False,
         XmNwidth, PBWIDTH,
         XmNtopAttachment, XmATTACH_FORM,
         XmNtopOffset, 10,
         XmNleftAttachment, XmATTACH_POSITION,
         XmNleftPosition, 50,
         XmNleftOffset, -PBWIDTH / 2,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNbottomOffset, 10,
         NULL);

      closePB = XtVaCreateManagedWidget ("Close",
         xmPushButtonWidgetClass, pbform,
         XmNwidth, PBWIDTH,
         XmNtopAttachment, XmATTACH_FORM,
         XmNtopOffset, 10,
         XmNleftAttachment, XmATTACH_POSITION,
         XmNleftPosition, 80,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNbottomOffset, 10,
         XmNrightAttachment, XmATTACH_POSITION,
         XmNrightPosition, 90,
         NULL);

      XtManageChild (pbform);

      i=0;
      XtSetArg (args[i], XmNrows, 12); i++;
      XtSetArg (args[i], XmNeditMode, XmMULTI_LINE_EDIT); i++;
      XtSetArg (args[i], XmNeditable, False); i++;
      XtSetArg (args[i], XmNscrollHorizontal, False); i++;
      XtSetArg (args[i], XmNwordWrap, True); i++;
      XtSetArg (args[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
      XtSetArg (args[i], XmNtopWidget, topicLabel); i++;
      XtSetArg (args[i], XmNleftAttachment, XmATTACH_FORM); i++;
      XtSetArg (args[i], XmNbottomAttachment, XmATTACH_WIDGET); i++;
      XtSetArg (args[i], XmNbottomWidget, pbform); i++;
      XtSetArg (args[i], XmNrightAttachment, XmATTACH_FORM); i++;

      helpTxt = XmCreateScrolledText (helpDiag, (char *)"helpTxt", args, i);

      /* "Find" button callback */
      XtAddCallback (findPB, XmNactivateCallback, popupFindCB,
         XtParent (helpDiag));

      /* "Find Agn" button callback */
      XtAddCallback (findAgnPB, XmNactivateCallback, doFindCB,
         (XtPointer) FIND_AGN);

      /* "Cancel" button callback */
      XtAddCallback (closePB, XmNactivateCallback, popdownCB, helpDiag);

      XtManageChild (helpTxt);
   }

   /* Load the Help window label and text */
   xs = XmStringCreateLtoR ((char *)helpTopics[topicNum], XmFONTLIST_DEFAULT_TAG);
   XtVaSetValues (topicLabel,
      XmNlabelString, xs,
      NULL);
   XmStringFree (xs);

   /* save the section number and load the text wid with help */
   sec = topicNum;
   XtVaSetValues (helpTxt,
      XmNvalue, helpText[topicNum],
      NULL);

   /* New find operation so... */
   strcpy (pattern, "");

   XtManageChild (helpDiag);      /* pop it up */
}


/*
 * popdownCB - popdown the help window
 */
void Help::popdownCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   XtVaSetValues (findAgnPB,
      XmNsensitive, False,
      NULL);

   XtUnmanageChild ((Widget) cdata); 
}


/*
 * popupFindCB - popup the prompt dialog - The OK button and Apply buttons
 * are renamed "This Section" and "All Sections".
 */
void Help::popupFindCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   int i, j;
   static Widget promptDiag;
   XmString xms[3];

   if (promptDiag == NULL)
   {
      promptDiag = XmCreatePromptDialog ((Widget)cdata,
                                         (char *)"promptDiag", NULL, 0);

      /* set title bar to WIN_TITLE */
      XtVaSetValues (XtParent (promptDiag),
         XmNtitle, WIN_TITLE,
         #if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
         XmNiconPixmap, pixmap,
         #endif
         XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
         NULL);

      /*
       * Unmanage the Help button and Manage the Apply button
       * Change there labels to "This Section" and "All Sections"
       */
      XtUnmanageChild (XmSelectionBoxGetChild(promptDiag,
          XmDIALOG_HELP_BUTTON));
      XtManageChild (XmSelectionBoxGetChild (promptDiag,
         XmDIALOG_APPLY_BUTTON));

      /* Change the OK and APPLY button label to "This Section" */
      i = 0;
      xms[i] = XmStringCreateLocalized ((char *)"This Section"); i++;
      xms[i] = XmStringCreateLocalized ((char *)"All Sections"); i++;
      xms[i] = XmStringCreateLocalized ((char *)"Enter Search String"); i++;

      XtVaSetValues (promptDiag,
         XmNokLabelString,xms[0],
         XmNapplyLabelString, xms[1],
         XmNselectionLabelString, xms[2],
         NULL);

      for (j=0; j<i; j++)
      {
         XmStringFree (xms[j]);
      }

      /* "This Section" PB callback */
      XtAddCallback (promptDiag, XmNokCallback, doFindCB,
        (XtPointer) THIS_SECTION);

      /* "All Sections" PB callback */
      XtAddCallback (promptDiag, XmNapplyCallback, doFindCB,
        (XtPointer) ALL_SECTIONS);
   }

   /* New find, so clear any highlights */
   XmTextSetHighlight (helpTxt, 0, strlen (helpText[sec]), XmHIGHLIGHT_NORMAL);
   XtManageChild (promptDiag);
}

/*
 * doFindCB - find a pattern within the help text
 */
void Help::doFindCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   char *pat;
   static int flag, start, start_sec;
   XmString xs;

   if ((long)cdata == THIS_SECTION || (long)cdata == ALL_SECTIONS) /* new find? */
   {
      flag = (long)cdata;  /* save THIS or ALL */
      start = 0;
      start_sec = sec;

      /* Get the find text and then clear the text box */
      XtVaGetValues (XmSelectionBoxGetChild (w, XmDIALOG_TEXT),
         XmNvalue, &pat,
         NULL);
      strncpy (pattern, pat, 40);

      /* try removing this */
      XtVaSetValues (XmSelectionBoxGetChild (w, XmDIALOG_TEXT),
         XmNvalue, "",
         NULL);

      /* Since we have find text, then findAgn is valid */
      XtVaSetValues (findAgnPB,
         XmNsensitive, True,
         NULL);
      XtFree (pat);
      XtUnmanageChild (w);  /* apply btn/all section button?*/
   }

   /* Try to find it */
   if ((found = findNoCase((char *)helpText[sec] + start, pattern)) != NULL)
   {       /* found it */
      start = found - &helpText[sec][0];
   
      XmTextSetHighlight (helpTxt, start,
         start + strlen (pattern),
         XmHIGHLIGHT_SELECTED);

      XmTextShowPosition (helpTxt, start);

      /* Update stuff */
      start = start + strlen (pattern);
      return;
   }
   else    /* didnt find it */
   {
      start = 0;
      /* Should we go to next section? */
      if (flag == THIS_SECTION) /* if this section only */
      {
         noMatchDiag();
         return;
      }
      else
      {
         sec++;
         if (sec >= NUM_TOPICS)
         {
            sec = 1;
         }

         /* Load the Help window label and text */
         xs = XmStringCreateLtoR ((char *)helpTopics[sec], XmFONTLIST_DEFAULT_TAG);
         XtVaSetValues (topicLabel,
            XmNlabelString, xs,
            NULL);
         XmStringFree (xs);

         /* Load the next section to the text widget */
         XtVaSetValues (helpTxt,
            XmNvalue, helpText[sec],
            NULL);

         if (sec == start_sec)  
         {
            noMatchDiag();
            return;
         }
         doFindCB(w, FIND_AGN, cbs);
      }
   }
}

/*
 * noMatch Dialog
 */
void Help::noMatchDiag()
{ 
XmString xs;
static Widget noMatchDiag;

   if (noMatchDiag == NULL)
   {
      noMatchDiag = XmCreateInformationDialog (XtParent(helpDiag),
                    (char *)"noMatchError", NULL, 0);

      XtVaSetValues (XtParent(noMatchDiag),
         XmNtitle, WIN_TITLE,
         #if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
         XmNiconPixmap, pixmap,
         #endif
         XmNmwmDecorations, MWM_DECOR_ALL | MWM_DECOR_RESIZEH,
         NULL);

      xs = XmStringCreateLocalized ((char *)"String Not Found");
      XtVaSetValues (noMatchDiag,
         XmNmessageAlignment, XmALIGNMENT_CENTER,
         XmNmessageString, xs,
         NULL);
      XmStringFree (xs);

      XtUnmanageChild (XmMessageBoxGetChild(noMatchDiag,
         XmDIALOG_HELP_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild(noMatchDiag,
         XmDIALOG_CANCEL_BUTTON));
   }

   XtVaSetValues (findAgnPB,
      XmNsensitive, False,
      NULL);

   XtManageChild (noMatchDiag);
   return;
}


/*
 * findNoCase - given a pattern and some text, search for
 * the pattern, ignoring case. 
 */
char* Help::findNoCase (char *text, char *pattern)
{
   char c, sc;
   int len;

   if ((c = *pattern++) != 0)
   {
      c = tolower(c);
      len = strlen(pattern);
      do
      {
         do
         {
            if ((sc = *text++) == 0)
               return NULL;
         } while (tolower(sc) != c);
      } while (strncasecmp(text, pattern, len) != 0);
      text--;
    }
    return (char *)text;
}
