from collections.abc import Callable
from typing import AnyStr, Protocol

class _HasHTML(Protocol):
    def __html__(self) -> str: ...

def html_escape(s: str | bytes | _HasHTML) -> str: ...
def header_docstring(header, rfc_section): ...
def warn_deprecation(text, version, stacklevel) -> None: ...

status_reasons: dict[int, str]
status_generic_reasons: dict[int, str]

def strings_differ(string1: AnyStr, string2: AnyStr, compare_digest: Callable[[AnyStr, AnyStr], bool] = ...) -> bool: ...
