/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef NOTICEMENU_H
#define NOTICEMENU_H

#include <QObject>
#include <QMenu>
#include <QRadioButton>
#include <QButtonGroup>
#include <QFrame>

#include "kswitchbutton.h"
using namespace kdk;

class NoticeMenu : public QMenu
{
    Q_OBJECT
public:
    NoticeMenu(QWidget *parent = nullptr);

    void initStaus(bool voiceEnable, bool detailEnable, bool showEnable, int id);
    static QFrame *setLine();
private:
    void initUi();
    void setFrame(QFrame *frame, QString str, KSwitchButton *btn);
    void setFrame(QFrame *frame, QString str, QRadioButton *btn);
    void setConnect();

private:
    KSwitchButton *mVoiceBtn = nullptr;
    KSwitchButton *mDetailBtn = nullptr;
    KSwitchButton *mShowBtn = nullptr;
    QButtonGroup *mStyleGrounp = nullptr;
    QRadioButton *mNoneBtn = nullptr;
    QRadioButton *mMutativeBtn = nullptr;
    QRadioButton *mAlwaysBtn = nullptr;

protected:
    void showEvent(QShowEvent *event);

Q_SIGNALS:
    void voiceSignals(bool checked);
    void detailSignals(bool checked);
    void showSignals(bool checked);
    void styleBtnSignals(int id);
};

#endif // NOTICEMENU_H
