/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mpris_controller_adaptor.h"
#include <QtCore/QMetaObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>

/*
 * Implementation of adaptor class MprisControllerAdaptor
 */

MprisControllerAdaptor::MprisControllerAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
    // constructor
    setAutoRelaySignals(true);
}

MprisControllerAdaptor::~MprisControllerAdaptor()
{
    // destructor
}

QStringList MprisControllerAdaptor::supportOperations() const
{
    // get the value of property supportOperations
    return qvariant_cast< QStringList >(parent()->property("supportOperations"));
}

void MprisControllerAdaptor::operation(const QString &operation)
{
    // handle method call org.ukui.mpris.controller.operation
    QMetaObject::invokeMethod(parent(), "operation", Q_ARG(QString, operation));
}

