/*
 * Copyright (C) 2014 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: James Henstridge <james.henstridge@canonical.com>
 */

#ifndef SCOPES_SCOPE_H
#define SCOPES_SCOPE_H

#include <unity/scopes/Category.h>
#include <unity/scopes/SearchReply.h>
#include <unity/scopes/ScopeBase.h>
#include <unity/scopes/Variant.h>

class ScopesScope : public unity::scopes::ScopeBase
{
    friend class ScopesQuery;
public:
    virtual void start(std::string const&) override;
    virtual void stop() override;

    virtual unity::scopes::SearchQueryBase::UPtr search(unity::scopes::CannedQuery const &q, unity::scopes::SearchMetadata const& hints) override;
    virtual unity::scopes::PreviewQueryBase::UPtr preview(unity::scopes::Result const& result, unity::scopes::ActionMetadata const& hints) override;

private:
    unity::scopes::ScopeProxy online_scope;
};

class ScopesQuery : public unity::scopes::SearchQueryBase
{
public:
    ScopesQuery(ScopesScope &scope, unity::scopes::CannedQuery const& query, unity::scopes::SearchMetadata const& metadata);
    virtual void cancelled() override;
    virtual void run(unity::scopes::SearchReplyProxy const&reply) override;

private:
    void surfacing_query(unity::scopes::SearchReplyProxy const &reply);
    void search_query(unity::scopes::SearchReplyProxy const &reply);

    void push_scope_result(unity::scopes::SearchReplyProxy const &reply, unity::scopes::ScopeMetadata const& item, unity::scopes::Category::SCPtr const& category);

    const ScopesScope &scope;
};

class ScopesPreview : public unity::scopes::PreviewQueryBase
{
public:
    ScopesPreview(ScopesScope &scope, unity::scopes::Result const& result, unity::scopes::ActionMetadata const& metadata);
    virtual void cancelled() override;
    virtual void run(unity::scopes::PreviewReplyProxy const& reply) override;

private:
    const ScopesScope &scope;
};

#endif
