#include	<stdio.h>

void
getbytes(fp, cp, n)	/* get n bytes from file fp */
register FILE *fp;	/* file pointer	 */
register char *cp;	/* character pointer */
register int n;		/* number of bytes  */
{
    (void)fread((char *)cp, 1, n, fp);
}

void
skipbytes(fp, n)
FILE *fp;
int n;
{
    (void)fseek(fp, (long)n, 1);
}

int
getuint(fp, n)		/* return n byte quantity from file fd */
register FILE *fp;	/* file pointer    */
register int n;		/* number of bytes */
{
    unsigned char s[sizeof(int)];

    (void)fread((char *)s, 1, n, fp);
    return (makeuint(s, n));
}

int
getint(fp, n)	/* return n byte quantity from file fd */
FILE *fp;	/* file pointer    */
int n;		/* number of bytes */
{
    unsigned char s[sizeof(int)];

    (void)fread((char *)s, 1, n, fp);
    return (makeint(s, n));
}

void
putbytes(fp, cp, n)	/* get n bytes from file fp */
register FILE *fp;	/* file pointer	 */
register char *cp;	/* character pointer */
register int n;		/* number of bytes  */
{
    (void)fwrite((char *)cp, 1, n, fp);
}

putuint(fp, x, n)
register FILE *fp;	/* file pointer	 */
unsigned int x;
register int n;		/* number of bytes */
{
    if (n > 0) {
	putuint(fp, x>>8, n-1);
	putc(x&0xff, fp);
    }
}


Fatal(fmt, a, b, c)	/* issue a fatal error message */
char *fmt;		/* format */
char *a, *b, *c;	/* arguments */
{
    (void)fprintf(stderr, fmt, a, b, c);
    exit(1);
}

Warning(fmt, a, b, c)	/* issue a warning */
char *fmt;		/* format   */
char *a, *b, *c;	/* arguments */
{
    (void)fprintf(stderr, fmt, a, b, c);
}
