# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#-------------------------------------------------------------------------------------------------------------

#Standards Modules
import os                               # use to determine how many core/cpu are presents
import subprocess
import Image
import StringIO
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp     # use by windows version for mplayer -wid parameter

#Modules from Videoporama project
from main_winDLG import *
from Transitions import *
from Render import *
from interface import *
from GlobalDefines import *

from RenderDlgSound import *        # Sound part of the render process
from RenderDlgMovie import *        # Movie part of the render process

class RenderDlg(QDialog,Ui_Render) :
    def __init__(self,VideoporamaInstance,IsPreview,parent=None):
      super(RenderDlg, self).__init__(parent)
      self.setupUi(self)
      self.setModal(True)
      self.VideoporamaInstance   = VideoporamaInstance                  # Access to main window
      self.ProcessWorking        = False                                # True if encoding process is working
      self.ForceClose            = False                                # True if user ask to close
      self.IsPreview             = IsPreview                            # True if process is Preview
      self.CurrentTAB            = 0                                    # Number of the current tab
      self.SetupInterfaceProcess = False                                # Flag to control Output format combo box
      self.StartRenderDateTime   = None
      self.StartRenderSequence   = 0                                    # First sequence to render for preview from

      self.imgpsec               = 0                                    # Output format : Frame per sec
      self.widthpict             = 0                                    # Output format : Width (in pixel)
      self.heightpict            = 0                                    # Output format : Height (in pixel)
      self.ext                   = ""                                   # Output format : file extension (avi, mpg, ...)
      self.Commande              = ""                                   # Output format : commande to be use
      self.img                   = []                                   # List of mylabel object
      self.ImgTime               = []                                   # List of mylabel.CalcImageTime() result
      self.totimage              = 0                                    # Number of frame to proceed
      self.IsSoundProduced       = False                                # True is sound track was produced

      self.MplayerPlayMode       = False                                # Is MPlayer currently play mode
      self.MplayerPauseMode      = False                                # Is MPlayer currently plause mode
      self.MplayerStartingMode   = False                                # Is MPlayer currently starting or restarting
      self.dureeTimer            = 10                                   # Pas du timer pour l'affichage du slidee (en ms)
      self.echelle               = 1000                                 # ?
      self.debutFin              = (0,0)                                # Position du slider

      #------------------------------------------------ Prepare self.XMLText (Overlaid text)
      self.XMLText = None
      #Search if the project have overlaid text
      xmlPoint=self.VideoporamaInstance.ProjectXMLObject.getElementsByTagName(u"Videoporama")[0]
      xmlText =xmlPoint.getElementsByTagName(u"Text")
      if xmlText.length>0 :
        xmlText=xmlText[0]
        # Be sure this child is type Overlaid (and not type image or Zoompoint)
        if xmlText.getAttribute(u"Type")=="Overlaid":
          self.XMLText=Document()
          xmlRoot=self.XMLText.createElement(u"SaveXML")
          self.XMLText.appendChild(xmlRoot)
          xmlRoot.appendChild(self.VideoporamaInstance.ProjectXMLObject.importNode(xmlText,True))

      #------------------------------------------------ Prepare self.PThread (for commande witch use muti-thread)
      self.PThread =u""
      # try to find the number of core/cpu for encoder how can use it
      try :
        if isWindows() :
          try:
            NbrCPU= int(os.environ['NUMBER_OF_PROCESSORS'])
          except:
            NbrCPU=1
        else:
          try:
            NbrCPU=int(os.sysconf('SC_NPROCESSORS_ONLN'))
          except:
            NbrCPU=1
        if NbrCPU<2: self.PThread=""
        else: self.PThread=u" -threads "+unicode(NbrCPU)
      except:
        None

      #------------------------------------------------ Prepare Objects in the dialog box
      #Prepare 2 QLablel for MPlayer process
      color = QColor(0, 0, 0)
      self.viewimg.setAutoFillBackground(True)
      self.cibleVideo.setAutoFillBackground(True)
      self.viewimg.setPalette(QPalette(color))
      self.cibleVideo.setPalette(QPalette(color))
      self.viewimg.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
      self.cibleVideo.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
      if int(self.VideoporamaInstance.imgformat)==1 : 
        self.viewimg.setFixedSize(426,240)
        self.cibleVideo.setFixedSize(426,240)
      else :
        self.viewimg.setFixedSize(320,240)
        self.cibleVideo.setFixedSize(320,240)

      #------------------------------------------------ Handler and Enabled buttons
      # Help buttons
      self.connect(self.ViewResultBTHelp,SIGNAL("pressed()"),self.Help)
      self.connect(self.ProgressBTHelp,SIGNAL("pressed()"),self.Help)
      self.connect(self.RenderBTHelp,SIGNAL("pressed()"),self.Help)

      # Replay preview button
      self.ReplayBT.setEnabled(False)               # Enabled only when process was stopped or ended
      self.ReplayBT.setVisible(self.IsPreview)      # Visible only when Preview mode
      self.connect(self.ReplayBT,SIGNAL("pressed()"),self.ProgressProcess)

      # Stop process button
      self.StopProcessBT.setEnabled(False)          # Enabled only when process working
      self.connect(self.StopProcessBT,SIGNAL("pressed()"),self.StopRender)
      
      # Close buttons
      self.ProgressBTClose.setEnabled(self.ProcessWorking==False)
      self.connect(self.ProgressBTClose,SIGNAL("pressed()"),self.reject)
      self.connect(self.ViewResultBTClose,SIGNAL("pressed()"),self.reject)

      #------------------------------------------------ Init TAB depending on Preview or Render ask
      if self.IsPreview==False : 
        self.CurrentTAB = 0
        self.Tab.setTabEnabled(0,True)
        self.Tab.setCurrentIndex(self.CurrentTAB)
        self.Tab.setTabEnabled(1,False)
        self.Tab.setTabEnabled(2,False)

        #----------------------Output Format Definition
        self.SetupInterfaceProcess=True
        List=self.VideoporamaInstance.OutputOFDXMLObject.GetOFDDeviceTypeCBList(self.VideoporamaInstance.win.imgformat.currentIndex())
        self.DeviceTypeCB.addItems(List)
        self.DeviceTypeCB.setCurrentIndex(self.DeviceTypeCB.findText(self.VideoporamaInstance.OFDDeviceType))
        self.ChgDeviceType(self.DeviceTypeCB.currentIndex())
        self.DeviceModelCB.setCurrentIndex(self.DeviceModelCB.findText(self.VideoporamaInstance.OFDDeviceModel))
        self.ChgDeviceModel(self.DeviceModelCB.currentIndex())
        self.OutputCodecCB.setCurrentIndex(self.OutputCodecCB.findText(self.VideoporamaInstance.OFDOutputCodec))
        self.ChgOutputCodec(self.OutputCodecCB.currentIndex())
        self.SetupInterfaceProcess=False
        self.OutputFormatCB.setCurrentIndex(self.OutputFormatCB.findText(self.VideoporamaInstance.OFDOutputFormat))
        self.ChgOutputFormat(self.OutputFormatCB.currentIndex())

        self.connect(self.DeviceTypeCB,SIGNAL("currentIndexChanged(int)"),self.ChgDeviceType)
        self.connect(self.DeviceModelCB,SIGNAL("currentIndexChanged(int)"),self.ChgDeviceModel)
        self.connect(self.OutputCodecCB,SIGNAL("currentIndexChanged(int)"),self.ChgOutputCodec)
        self.connect(self.OutputFormatCB,SIGNAL("currentIndexChanged(int)"),self.ChgOutputFormat)
        self.connect(self.RenderBTOk,SIGNAL("pressed()"),self.accept)
        self.connect(self.RenderBTCancel,SIGNAL("pressed()"),self.reject)

        #----------------------Output filename
        self.outputfile.setText(self.VideoporamaInstance.outputFile)
        self.ChgOutputFile()
        self.connect(self.outputfilea,SIGNAL("clicked()"),self.BrowseOutputFile)
        self.connect(self.outputfile,SIGNAL("editingFinished()"),self.ChgOutputFile)
      else :
        self.CurrentTAB = 1
        self.Tab.setTabEnabled(1,True)
        self.Tab.setCurrentIndex(self.CurrentTAB)
        self.Tab.setTabEnabled(0,False)
        self.Tab.setTabEnabled(2,False)

    #----------------------------------------------------------------------------------------
    # Handler for help buttons of the 3 TAB
    def Help(self):
      docw=DocHelp(self.VideoporamaInstance,self.VideoporamaInstance.qtapp.translate("Documentation","en-renderbox.html"),self)
      docw.show() 
      
    # Handler for OK button of the Render TAB
    def accept(self) :
      self.ProgressProcess()

    # Handler for 
    #  close button of the dialog box
    #  close button of the progress TAB
    #  close button of the view result TAB
    #  cancel button of the Render TAB
    def reject(self) :
      if self.ProcessWorking==True:
        self.ForceClose=True
      elif self.MplayerPlayMode==True:
        self.MPlayerStopBT()
        super(RenderDlg, self).accept()
      else:
        super(RenderDlg, self).accept()

    # Encoding progress from OK button of the Render TAB or when asked for Preview
    def ProgressProcess(self) :
      self.CurrentTAB = 1
      self.Tab.setTabEnabled(1,True)
      self.Tab.setCurrentIndex(self.CurrentTAB)
      self.Tab.setTabEnabled(0,False)
      
      self.DoRenderProcess()

    #----------------------------------------------------------------------------------------

    def DoRenderDisplayImg(self,img) :
      if self.IsPreview==False:
        if int(self.VideoporamaInstance.imgformat) == 0 : wimg = 320
        else : wimg = 426
        self.viewimg.setPixmap(QPixmap.fromImage(img.ToRenderImageForDisplay(0,wimg,240)[0]))
        QCoreApplication.processEvents()
        #self.VideoporamaInstance.WaitEvents()

    def DoRenderInfoSound(self,CurJobText,Position) :
      if self.IsPreview==False and self.StartRenderDateTime!=None:
        DiffTime=float(self.StartRenderDateTime.secsTo(QDateTime().currentDateTime()))
        if DiffTime==0: DiffTime=1   # To don't have divide by 0 error
        seconde=str(DiffTime % 60).split(".")
        minute=int(DiffTime / 60)
        heure=int(minute / 60)
        CurJobText=CurJobText+" (%s:%s:%s)" % (str(heure).rjust(2,'0'),str(minute).rjust(2,'0'),seconde[0].rjust(2,'0'))
      self.info.setText(CurJobText)
      self.SoundProgressBar.setValue(Position)
      QCoreApplication.processEvents()
      #self.VideoporamaInstance.WaitEvents()

    def DoRenderInfoFrame(self,CurJobText,frame) :
      if frame!=-1: Text2=self.VideoporamaInstance.qtapp.translate("Render","processing frame ")+unicode(frame)+self.VideoporamaInstance.qtapp.translate("Render"," from ")+unicode(int(self.totimage))
      else : Text2=""
      if CurJobText==None : CurJobText=Text2
      else :                CurJobText=CurJobText+"\n"+Text2
      if self.IsPreview==False and self.StartRenderDateTime!=None:
        DiffTime=float(self.StartRenderDateTime.secsTo(QDateTime().currentDateTime()))
        if DiffTime==0: DiffTime=1   # To don't have divide by 0 error
        seconde=str(DiffTime % 60).split(".")
        minute=int(DiffTime / 60)
        heure=int(minute / 60)
        CurJobText=CurJobText+" (%s:%s:%s - %s fps)" % (str(heure).rjust(2,'0'),str(minute).rjust(2,'0'),seconde[0].rjust(2,'0'),str(int(frame/DiffTime)))
      self.info.setText(CurJobText)
      if frame!=-1 : self.VideoProgressBar.setValue(frame)
      QCoreApplication.processEvents()
      #self.VideoporamaInstance.WaitEvents()

    #----------------------------------------------------------------------------------------
    # Display process in render video mode
    #----------------------------------------------------------------------------------------
    def ViewResultProcess(self) :
      self.CurrentTAB=2
      self.Tab.setTabEnabled(0,False)
      self.Tab.setTabEnabled(1,False)
      self.Tab.setTabEnabled(2,True)
      self.Tab.setCurrentIndex(self.CurrentTAB)
      self.MPlayerStartPlay()
    
    def MPlayerStartPlay(self) :
      self.SliderPos             = 0                  # New position use during slider mode
      self.OldSliderPos          = 0                  # Older position use during slider mode
      self.SliderMoving          = False              # True if current Slider moving
      self.dureeTimer            = 50                 # Pas du timer pour l'affichage du slidee (en ms)
      self.echelle               = 1000
      self.debutFin              = (0,0)
      self.ResultProcessCurPos   = 0
      self.ResultProcessDuration = 0
      self.MplayerStartingMode   = True               # Starting process start

      #----- Button control
      self.MplayerPlayMode  =False                    # est-ce que la vidéo est lue?
      self.MplayerPauseMode =False                    # est-ce que la vidéo est en pause?
      #----- Prepare MPlayer process
      self.timer          = QTimer(self)
      self.mplayerProcess = QProcess(self)
      self.mplayerProcess.setProcessChannelMode(QProcess.MergedChannels)

      if self.VideoporamaInstance.imgformat == 1: Aspect="-aspect 16:9"
      else:                                       Aspect="-aspect 4:3"
      
      if isWindows() : 
        if self.VideoporamaInstance.AEROCOMPATIBILITY==True:
          Commande=QString("\"")+self.VideoporamaInstance.MP+"mplayer.exe\" -osdlevel 0 -slave -quiet "+Aspect+" -wid "+str(self.cibleVideo.winId().__hex__())+" -vo directx:noaccel \""+self.VideoporamaInstance.outputFile+"\""
        else : 
          Commande=QString("\"")+self.VideoporamaInstance.MP+"mplayer.exe\" -osdlevel 0 -slave -quiet "+Aspect+" -wid "+str(self.cibleVideo.winId().__hex__())+" -vo gl:glfinish \""+self.VideoporamaInstance.outputFile+"\""
      else :
        Commande=QString(self.VideoporamaInstance.MP)+"mplayer -osdlevel 0 -slave -quiet "+Aspect+" -wid "+QString.number(self.cibleVideo.winId())+" \""+self.VideoporamaInstance.outputFile+"\""

      self.mplayerProcess.start(unicode(Commande))
      self.slider.setEnabled(True)

      self.connect(self.mplayerProcess, SIGNAL('readyReadStandardOutput()'), self.MPlayerMessage)
      self.connect(self.mplayerProcess, SIGNAL('finished(int,QProcess::ExitStatus)'), self.MPlayerFinished)
      self.connect(self.MPlayerPlayPauseBT, SIGNAL('clicked()'), self.MPlayerPlayPauseBTPressed)
      self.connect(self.bout_Arret, SIGNAL('clicked()'), self.MPlayerStopBT)
      self.connect(self.timer, SIGNAL('timeout()'), self.MPlayerTimerEvent)
      #----- Slider control
      self.connect(self.slider, SIGNAL('sliderPressed()'), self.MPlayerSliderPressed)
      self.connect(self.slider, SIGNAL('sliderReleased()'), self.MPlayerSliderReleased)
      self.connect(self.slider, SIGNAL('sliderMoved(int)'), self.MPlayerSliderMoved)

      if not self.mplayerProcess.waitForStarted(3000):
        QMessageBox.critical(self, self.VideoporamaInstance.qtapp.translate("Render","Warning"), self.VideoporamaInstance.qtapp.translate("Render","Error when starting mplayer"))
        return False

      # donne le temps toutes les x secondes
      self.MplayerPlayMode, self.MplayerPauseMode = True, False
      self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_play.png"))
      self.slider.setEnabled(True) # évite un bogue
      self.mplayerProcess.write("seek 0 2\n")
      self.timer.start(self.dureeTimer)

    #--------------------------------------------------------------------
    #Function call each time a Timer Event is send
    #--------------------------------------------------------------------
    def MPlayerTimerEvent(self):
      if self.MplayerStartingMode==True: return

      if self.SliderMoving==True : # if timer mode is slider mode
        if self.OldSliderPos!=self.ResultProcessCurPos:
          #Seek mplayer keeping the pause
          pos=float(self.ResultProcessCurPos)/float(self.echelle)
          pos="%0.1f"%pos
          self.mplayerProcess.write("pausing_keep seek "+pos+" 2\n") # SEEK x 2=is a seek to an absolute position of <value> seconds
          chrono= QTime(0,0,0).addMSecs(self.ResultProcessCurPos*self.echelle).toString("HH:mm:ss.zzz")+" / "+\
                  QTime(0,0,0).addMSecs(self.ResultProcessDuration*self.echelle).toString("HH:mm:ss.zzz")
          self.tempsChrono.setText(chrono)
          self.OldSliderPos=self.ResultProcessCurPos         # Save current position
      elif self.mplayerProcess.state()!=QProcess.NotRunning: 
        # Ask mplayer for current position - Message will be receive by MPlayerMessage
        if self.MplayerPauseMode!=True :
          self.mplayerProcess.write("get_time_pos\n")

    #--------------------------------------------------------------------
    #Function call each time a Slider process start
    #--------------------------------------------------------------------
    def MPlayerSliderPressed(self):
      self.OldSliderPos=-1              # Force update of older position
      self.SliderMoving=True            # Changer timer mode to slider mode

      # If MPlayer is playing : set it to pause
      if self.mplayerProcess.state() == QProcess.NotRunning: 
        self.MPlayerStartPlay()
      else: # play or pause
        self.mplayerProcess.write("pause\n")
        self.MplayerPlayMode, self.MplayerPauseMode = True, True
        self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_pause.png"))

    #--------------------------------------------------------------------
    #Slider process
    #--------------------------------------------------------------------
    def MPlayerSliderMoved(self, pos):
      self.ResultProcessCurPos=pos

    #--------------------------------------------------------------------
    #Function call each time a Slider process stop
    #--------------------------------------------------------------------
    def MPlayerSliderReleased(self):
      if self.SliderMoving==True:
        pos=float(self.ResultProcessCurPos)/float(self.echelle)
        pos="%0.1f"%pos
        #If mplayer playing when slider process start
        self.mplayerProcess.write("seek " +pos+" 2\n") # SEEK x 2=is a seek to an absolute position of <value> seconds
        self.MplayerPlayMode, self.MplayerPauseMode = True, False
        self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_play.png"))
        self.SliderMoving=False   # Changer timer mode to normal

    def MPlayerFinished(self, statutDeSortie, codeSortie):
      #-------------- Debug
      if statutDeSortie==1: print "Crash de mplayer lors de la fin de la lecture de la vidéo"
      #-------------- Debug
      self.MplayerPlayMode, self.MplayerPauseMode = False, False
      self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_play.png"))
      self.timer.stop()
      self.SliderMoving=False
      self.slider.setEnabled(False) # évite un bogue

    def MPlayerStopBT(self):
      # Arrete la lecture de la vidéo et réinitialise les icones et variables
      if self.mplayerProcess.state() == QProcess.NotRunning: # ajouté pour ne pas avoir de bogue à la fin de la lecture de la vidéo.
            return True
      
      self.mplayerProcess.write("quit\n") # arrêt de la vidéo
      
      # au cas où mplayer ne s'arrêterait pas au bout de 3 sec
      if not self.mplayerProcess.waitForFinished(3000):
        QMessageBox.critical(self, self.VideoporamaInstance.qtapp.translate("Render","Warning"), self.VideoporamaInstance.qtapp.translate("Render","Error when stoping mplayer"))
        return False
      
      self.slider.setEnabled(False) # évite un bogue
      
      self.tempsChrono.setText("0:00:00:000")
      self.tempsChrono.repaint()
      self.slider.setValue(0)
      self.MplayerPlayMode, self.MplayerPauseMode = False, False
      self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_play.png"))
      return True
    
    #--------------------------------------------------------------------
    #Function call each time mplayer send us a message
    #--------------------------------------------------------------------
    def MPlayerMessage(self):
      # récupère les lignes d'information émises par QProcess (mplayerProcess) et en tire les conséquences

      while self.mplayerProcess.canReadLine(): # renvoie True si une ligne complète peut être lue à partir du système
        # stocker l'ensemble des bits d'une ligne
        tampon=QByteArray(self.mplayerProcess.readLine()) # readline: lit une ligne ascii à partir du système
        tampon.replace(QByteArray("\n"), QByteArray(""))

        # On vérifie si on a eu des réponses
        if tampon.startsWith("Playing"):
          self.mplayerProcess.write("get_time_length\n")   #ask mplayer for movie length

        # réponse à get_time_length : ANS_LENGTH=xx.yy
        elif tampon.startsWith("ANS_LENGTH"):
          tampon.remove(0, 11) # vire ANS_LENGTH=
          tampon.replace(QByteArray("'"), QByteArray(""))
          tampon.replace(QByteArray(" "), QByteArray(""))
          tampon.replace(QByteArray("\r"), QByteArray("")) # -> 279.38
          self.ResultProcessDuration = tampon.toFloat()[0] # (279.3800048828125, True) <type 'tuple'>
          self.slider.setMaximum(self.ResultProcessDuration*self.echelle)
          DrawMovieRuller(self.CustomWidget,None,None,QTime(0,0,0).addMSecs(self.ResultProcessDuration*self.echelle))
          self.MplayerStartingMode=False  # Starting process end

        # réponse à get_time_pos : ANS_TIME_POSITION=xx.y
        elif tampon.startsWith("ANS_TIME_POSITION"):
          tampon.remove(0, 18) # vire ANS_TIME_POSITION=
          tampon.replace(QByteArray("'"), QByteArray(""))
          tampon.replace(QByteArray(" "), QByteArray(""))
          tampon.replace(QByteArray("\r"), QByteArray(""))
          self.ResultProcessCurPos = tampon.toFloat()[0] # (1.3999999761581421, True) <type 'tuple'>
          # récupération du temps courant: utile dans certains cadres
          self.temps = self.ResultProcessCurPos
          temps = float("%.1f" %self.temps)
          if self.debutFin!=(0,0) and self.debutFin[1]==temps:
            self.MPlayerStopBT()
            return
          self.slider.setValue(self.ResultProcessCurPos*self.echelle)
          # affichage du temps sous la forme h:mm:ss:ms dans un bouton
          chrono= QTime(0,0,0).addMSecs(self.ResultProcessCurPos*self.echelle).toString("HH:mm:ss.zzz")+" / "+\
                  QTime(0,0,0).addMSecs(self.ResultProcessDuration*self.echelle).toString("HH:mm:ss.zzz")
          self.tempsChrono.setText(chrono)

        #Ligne non pris en charge : l'affiche
        else :
          if tampon!="" : print tampon

    def MPlayerPlayPauseBTPressed(self):
      #lecture/pause de la vidéo avec mplayer
      if not self.MplayerPlayMode or self.mplayerProcess.state()==QProcess.NotRunning:
        self.MPlayerStartPlay()                           # lecture de la vidéo

      elif self.MplayerPlayMode and not self.MplayerPauseMode: # lecture -> pause
        self.MplayerPlayMode, self.MplayerPauseMode = True, True
        self.mplayerProcess.write("pause\n")
        self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_pause.png"))
        self.slider.setEnabled(True) # évite un bogue

      elif self.MplayerPlayMode and self.MplayerPauseMode: # pause -> lecture
        # prévoir le cas où mplayer ne se mettrait pas en pause au bout de 3 sec
        self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_play.png"))
        self.slider.setEnabled(True) # évite un bogue
        self.MplayerPlayMode, self.MplayerPauseMode = True, False
        self.mplayerProcess.write("play\n")

    #----------------------------------------------------------------------------------------

    # Function call each time Output Filename is set by user
    def ChgOutputFile(self):
      try:
        ext=self.VideoporamaInstance.OutputOFDXMLObject.GetAllProperties(
          self.DeviceTypeCB.currentText(),
          self.DeviceModelCB.currentText(),
          self.OutputCodecCB.currentText(),
          self.VideoporamaInstance.win.imgformat.currentIndex(),
          self.OutputFormatCB.currentText())[4]
        oof=self.outputfile.text()
        if not oof.isEmpty() : 
          of=QFileInfo(oof).path()+QDir().separator().toAscii()+QFileInfo(oof).baseName()+ext
        else: of=QString("")
      except:
        of=self.outputfile.text()
      if not of.isEmpty() :
        if isWindows()!=True : 
          if of.startsWith(u"~/") :
            of.replace(0,1,self.VideoporamaInstance.homeDir)
          if not of.startsWith(u"/") :
            Path=QDir().toNativeSeparators(self.VideoporamaInstance.lastDirRender)
            if Path[len(Path)-1]!=QDir().separator().toAscii() : Path=Path+QDir().separator().toAscii()
            of=Path+of
        else :
          if len(of)>2 and (of[1]==":" or (of[0]=="\\" and of[1]=="\\")):
            None
          else : 
            Path=QDir().toNativeSeparators(self.VideoporamaInstance.lastDirRender)
            if Path[len(Path)-1]!=QDir().separator().toAscii() : Path=Path+QDir().separator().toAscii()
            of=Path+of
            
        if unicode(of)!=self.VideoporamaInstance.outputFile:
          self.VideoporamaInstance.outputFile=unicode(of)
          self.VideoporamaInstance.lastDirRender=QFileInfo(of).dir().absolutePath()
          self.outputfile.setText(of)
          self.VideoporamaInstance.App_SetModifiedFlag()
      self.RenderBTOk.setEnabled(self.OutputFormatCB.currentText()!="" and self.outputfile.text()!="")
      self.outputfilea.setEnabled(self.OutputFormatCB.currentText()!="")
      self.outputfile.setEnabled(self.OutputFormatCB.currentText()!="")

    # Function for selecting an Output Filename with browse
    def BrowseOutputFile(self):
      ext=self.VideoporamaInstance.OutputOFDXMLObject.GetAllProperties(
          self.DeviceTypeCB.currentText(),
          self.DeviceModelCB.currentText(),
          self.OutputCodecCB.currentText(),
          self.VideoporamaInstance.win.imgformat.currentIndex(),
          self.OutputFormatCB.currentText())[4]
      SearchExt="*"+ext+" ("+self.OutputCodecCB.currentText()+")"
      file=QFileDialog.getSaveFileName(self, self.VideoporamaInstance.qtapp.translate("Render","Select Output Video File"),self.VideoporamaInstance.lastDirRender,SearchExt)
      if file!="" and file!=self.VideoporamaInstance.outputFile :
        self.outputfile.setText(file)
        self.ChgOutputFile()

    # Function for selecting device type for output format
    def ChgDeviceType(self,index):
      self.DeviceModelCB.clear()
      List=self.VideoporamaInstance.OutputOFDXMLObject.GetOFDDeviceModelCBList(self.DeviceTypeCB.currentText(),self.VideoporamaInstance.win.imgformat.currentIndex())
      self.DeviceModelCB.addItems(List)
      self.ChgDeviceModel(0)

    # Function for selecting device model for output format
    def ChgDeviceModel(self,index):
      self.OutputCodecCB.clear()
      List=self.VideoporamaInstance.OutputOFDXMLObject.GetOFDOutputCodecCBList(self.DeviceTypeCB.currentText(),self.DeviceModelCB.currentText(),self.VideoporamaInstance.win.imgformat.currentIndex())
      self.OutputCodecCB.addItems(List)
      self.ChgOutputCodec(0)

    # Function for selecting video codec for output format
    def ChgOutputCodec(self,index):
      self.OutputFormatCB.clear()
      List=self.VideoporamaInstance.OutputOFDXMLObject.GetOFDOutputFormatList(self.DeviceTypeCB.currentText(),self.DeviceModelCB.currentText(),self.OutputCodecCB.currentText(),self.VideoporamaInstance.win.imgformat.currentIndex())
      self.OutputFormatCB.addItems(List)
      self.ChgOutputFormat(0)
      if self.SetupInterfaceProcess==False: self.ChgOutputFile()

    # Function for selecting image format for output format
    def ChgOutputFormat(self,index):
      if self.SetupInterfaceProcess==False: 
        self.VideoporamaInstance.OFDDeviceType  =str(self.DeviceTypeCB.currentText())
        self.VideoporamaInstance.OFDDeviceModel =str(self.DeviceModelCB.currentText())
        self.VideoporamaInstance.OFDOutputCodec =str(self.OutputCodecCB.currentText())
        self.VideoporamaInstance.OFDOutputFormat=str(self.OutputFormatCB.currentText())
        if self.SetupInterfaceProcess==False:  self.ChgOutputFile()

#------------------------------------------------------------------------------------------------------------
# Render process
#------------------------------------------------------------------------------------------------------------

    def StopRender(self) :
      self.ForceClose=True

    def DoRenderProcess(self) :
      self.VideoporamaInstance.WaitEvents()  # be sure dialog box is ready to display progress bar

      self.ForceClose          = False                                       # True if user press the stop process button
      self.img                 = []                                          # Reset list of mylabel object
      self.ImgTime             = []                                          # Reset list of mylabel.CalcImageTime() result
      self.totimage            = 0                                           # Reset number of frame to proceed
      self.ws                  = self.VideoporamaInstance.T+u"audio.tmp.wav" # Temp wav file
      self.StartRenderDateTime = QDateTime().currentDateTime()               # Keep "now" to display process duration

      # Init TAB and buttons and sliders
      self.Tab.setTabEnabled(2,False)       # Disabled View Result TAB
      self.ReplayBT.setEnabled(False)       # Enabled only when process was stopped or ended
      self.SoundProgressBar.setMaximum(100)
      self.SoundProgressBar.setValue(0)
      self.VideoProgressBar.setValue(0)

      #----------------------------------------------
      # Prepare variable for rendering
      #----------------------------------------------
      if self.IsPreview==False :
        # Render mode : Ask OutputOFDXML Object
        Name,self.imgpsec,self.widthpict,self.heightpict,self.ext,self.Commande,TestAudio,TestVideo,TestFile=self.VideoporamaInstance.OutputOFDXMLObject.GetAllProperties(
          self.DeviceTypeCB.currentText(),
          self.DeviceModelCB.currentText(),
          self.OutputCodecCB.currentText(),
          self.VideoporamaInstance.win.imgformat.currentIndex(),
          self.OutputFormatCB.currentText())
        # Special case for AAC with ffmpeg 0.5
        if self.VideoporamaInstance.AACMode=="libfaac" : self.Commande.replace(u"aac -strict experimental", u"libfaac")
        # Define outfile
        self.Commande=self.Commande+u" \""+self.VideoporamaInstance.outputFile+u"\""
        # Specific for x264 how enable multi-threading
        self.Commande.replace(u"%THREAD%",self.PThread)
      else :
        # Preview mode : The variable are define here
        self.ext    =""
        self.imgpsec= 15

        # Prepare args for mplayer
        if isWindows() :
          PreviewArgs="-wid "+str(self.viewimg.winId().__hex__()) # reinterpret_cast<qlonglong> obligatoire, winId() ne se laissant pas convertir gentiment
          if self.VideoporamaInstance.AEROCOMPATIBILITY==True: PreviewArgs=PreviewArgs+" -vo directx:noaccel"
          else : PreviewArgs=PreviewArgs+" -vo gl:glfinish"
        else :
          PreviewArgs="-wid "+QString.number(self.viewimg.winId())

        # Construct commande for preview
        if self.VideoporamaInstance.imgformat == 1:
          self.widthpict  = 352
          self.heightpict = 198
          self.Commande=QString("'%MJPEGDIR%ppmtoy4m' -v 0 -n %FRAMENBR% -F 15:1 -S 420jpeg | '" \
            +u"%FFMPEGDIR%ffmpeg' -y -f yuv4mpegpipe -i - -i '%SOUNDFILE%' " \
            +u"-target pal-vcd "\
            +u"-aspect 16:9 - | '%MPLAYERDIR%mplayer' -cache 1024 "+unicode(PreviewArgs)+u" -aspect 16:9 -")
        else:
          self.widthpict  = 352
          self.heightpict = 240
          self.Commande=QString("'%MJPEGDIR%ppmtoy4m' -v 0 -n %FRAMENBR% -F 15:1 -S 420jpeg | '" \
            +u"%FFMPEGDIR%ffmpeg' -y -f yuv4mpegpipe -i - -i '%SOUNDFILE%' " \
            +u"-target pal-vcd "\
            +u"-aspect 4:3 -  | '%MPLAYERDIR%mplayer' -cache 1024 "+unicode(PreviewArgs)+u" -aspect 4:3 -")

      #------------------------------------------------------------
      # Prepare self.Commande
      #------------------------------------------------------------
      if isWindows() : 
        self.Commande.replace(u"'%MJPEGDIR%ppmtoy4m'", "\""+self.VideoporamaInstance.MJ+"ppmtoy4m.exe\"")
        self.Commande.replace(u"'%FFMPEGDIR%ffmpeg'","\""+self.VideoporamaInstance.I+"ffmpeg.exe\"")
        self.Commande.replace(u"'%MPLAYERDIR%mplayer'", "\""+self.VideoporamaInstance.MP+"mplayer.exe\"")
        self.Commande.replace(u"-vpre libx264-hq", "-fpre \""+self.VideoporamaInstance.I+"..\presets\libx264-hq.ffpreset\"")
        self.Commande.replace(u"'%SOUNDFILE%'", "\""+self.ws+"\"")
      else:
        self.Commande.replace(u"'%MJPEGDIR%ppmtoy4m'", "\""+self.VideoporamaInstance.MJ+"ppmtoy4m\"")
        self.Commande.replace(u"'%FFMPEGDIR%ffmpeg'","\""+self.VideoporamaInstance.I+"ffmpeg\"")
        self.Commande.replace(u"'%MPLAYERDIR%mplayer'", "\""+self.VideoporamaInstance.MP+"mplayer\"")
        self.Commande.replace(u"'%SOUNDFILE%'", "\""+self.ws+"\"")

      #------------------------------------------------------
      # Construct images files table and calculate totimage
      #------------------------------------------------------
      k=0
      self.totimage = 0
      while k<self.VideoporamaInstance.win.timeline.columnCount() :
        self.img.append(self.VideoporamaInstance.win.timeline.cellWidget(0,k))
        self.ImgTime.append(self.img[k].CalcImageTime(self.imgpsec))
        if k==(self.VideoporamaInstance.win.timeline.columnCount()-1): self.totimage+=self.ImgTime[k][1]
        else : self.totimage+=self.ImgTime[k][1]-self.ImgTime[k][5]
        k+=1
      # Now we can update command with totimage
      self.Commande.replace(u"%FRAMENBR%", str(int(self.totimage)))

      #------------------------------------------------------------
      # Init slider
      #------------------------------------------------------------
      self.VideoProgressBar.setMaximum(self.totimage)

      #------------------------------------------------------------
      # Sound preparation : check and abord if no sound file
      #------------------------------------------------------------
      if self.IsSoundProduced==False:
        self.IsSoundProduced=False
        self.convertSoundMix=RenderDlgSound(self.VideoporamaInstance,self,self.StartRenderSequence)
        if not self.convertSoundMix.ConvertSound() :
          QMessageBox.critical(self,self.VideoporamaInstance.qtapp.translate("Render","Error"),self.VideoporamaInstance.qtapp.translate("Render","Error with sound encoding process\nEncoding process abort"))
          return False # stop render box

        self.IsSoundProduced=True # Keep this information to not reproduce sound when replay is selected
        self.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Sound process done"),100)
      #------------------------------------------------------------
      # Movie Rendering
      #------------------------------------------------------------
      RenderMovie=RenderDlgMovie(self.VideoporamaInstance,self,self.StartRenderSequence)
      RenderMovie.RenderMovie()
      
    def SeqFrameDurationToString(self,SeqFrame):
      # definition of sound lenght
      if self.imgpsec==30 : SeqFrame=float(SeqFrame)*1001/30000
      else :                SeqFrame=float(SeqFrame)/self.imgpsec
      Length = float(SeqFrame)
      #Length=u"%s:"        % unicode(int(SeqFrame/3600)).rjust(2,'0')
      #Length=Length+u"%s:" % unicode(int((SeqFrame%3600)/60)).rjust(2,'0')
      #Length=Length+u"%s." % unicode(int(SeqFrame%60)).rjust(2,'0')
      #Length=Length+u"%s"  % unicode(int((SeqFrame-int(SeqFrame))*1000)).ljust(3,'0')
      return Length

