# -*- makefile -*-

# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1


# These are used for cross-compiling and for saving the configure script
# from having to guess our platform (since we know it already)
DEB_HOST_GNU_TYPE   ?= $(shell dpkg-architecture -qDEB_HOST_GNU_TYPE)
DEB_BUILD_GNU_TYPE  ?= $(shell dpkg-architecture -qDEB_BUILD_GNU_TYPE)


CFLAGS = -Wall -g

ifneq (,$(findstring noopt,$(DEB_BUILD_OPTIONS)))
	CFLAGS += -O0
else
	CFLAGS += -O2
endif

build: build-stamp

build-stamp:
	dh_testdir
	./configure --prefix=/usr  # not GNU autoconf configure!

	$(MAKE)

	touch build-stamp

clean:
	dh_testdir
	dh_testroot
	rm -f build-stamp 

	-$(MAKE) clean
	find . -name "*.o" -exec rm '{}' \;
	find . -name "*.a" -exec rm '{}' \;
	find . -wholename "*/.depend" -exec rm '{}' \;
	rm -f klapp_conf.h reloc.mk Makefile.conf built/target/klone-core-*
	rm -f kloned .wc .wc.old .real-*
	rm -f kloned $(shell cat debian/wsp.opt.binary)

	dh_clean 

install:: build
	dh_testdir
	dh_testroot
	dh_clean -k 
	dh_installdirs
	ln -s kloned $(shell cat debian/wsp.opt.binary)
	install $(shell cat debian/wsp.opt.binary) debian/*/usr/sbin/


# Build architecture-independent files here.
binary-indep: build install
# We have nothing to do by default.

# Build architecture-dependent files here.
binary-arch: build install
	dh_testdir
	dh_testroot
	dh_installchangelogs 
	dh_installdocs
	dh_installinit
	dh_install
	dh_link
	dh_strip
	dh_compress
	dh_fixperms
	dh_installdeb
	dh_shlibdeps
	dh_gencontrol
	dh_md5sums
	dh_builddeb

binary: binary-indep binary-arch
.PHONY: build clean binary-indep binary-arch binary install unapply-patches
