/*
 * Decompiled with CFR 0.152.
 */
import fr.ove.openmath.jome.Jome;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MathView
extends Applet
implements ActionListener,
ItemListener,
TextListener,
WindowListener {
    Jome j;
    JFrame standaloneWindow = null;
    JPanel controlPane;
    JPanel palette;
    JPanel paletteCards;
    CardLayout paletteCardsLayout;
    Choice paletteChoice;
    TextArea linearInput;
    JButton undoButton;
    JButton redoButton;
    boolean inAnApplet = true;
    String previousLinear = null;
    String[] undoBuffer = new String[50];
    int undoBufferCursor = 0;
    int undoBufferValidSize = 0;
    int undoBufferValidSizeMax = 0;
    Font bigFont = new Font("Helvetica", 0, 32);
    Font defaultFont = new Font("Helvetica", 0, 18);
    boolean Special_Fraction = false;

    public static String replace(String string, String string2, String string3) {
        if (string != null) {
            int n = string2.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) != -1) {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            return stringBuffer.toString();
        }
        return "";
    }

    public void setWindow(JFrame jFrame) {
        this.standaloneWindow = jFrame;
        this.inAnApplet = false;
    }

    public void toggleFont() {
        Jome jome = this.j;
        if (jome.getFont() == this.bigFont) {
            jome.setFont(this.defaultFont);
            this.linearInput.setFont(this.defaultFont);
        } else {
            jome.setFont(this.bigFont);
            this.linearInput.setFont(this.bigFont);
        }
        this.invalidate();
        jome.invalidate();
        this.linearInput.invalidate();
        this.linearInput.requestFocus();
        this.repaint();
        jome.repaint();
        this.linearInput.repaint();
    }

    public static void main(String[] stringArray) {
        MathView mathView = new MathView();
        JFrame jFrame = new JFrame();
        mathView.setWindow(jFrame);
        jFrame.add(mathView);
        jFrame.setTitle("WIMS JAVA INPUT");
        jFrame.addWindowListener(mathView);
        mathView.init();
        jFrame.pack();
        jFrame.setSize(640, 480);
        jFrame.setVisible(true);
        jFrame.validate();
        mathView.start();
        mathView.repaint();
    }

    private String removespecial(String string) {
        int n = string.indexOf("vlist(");
        if (n == -1) {
            return string;
        }
        String string2 = string;
        int n2 = 0;
        while (n >= 0) {
            if (++n2 > 1000) {
                return string2 + " vlist(a,b) syntax error";
            }
            int n3 = string.length();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int i = n + 5; i < n3; ++i) {
                if (n6 != 0) continue;
                char c = string.charAt(i);
                if (c == '(') {
                    ++n4;
                }
                if (c == ')') {
                    ++n5;
                }
                if (n5 == 0 || n4 != n5) continue;
                n6 = i;
            }
            String string3 = string.substring(n + 6, n6);
            int n7 = string3.indexOf(",");
            if (n7 < 0) {
                return string2 + " syntax error: comma missing\nvlist(a,b,c,d)";
            }
            int n8 = string3.length();
            String string4 = string3.substring(0, n8);
            if (string4.indexOf("vlist(") != -1) {
                return string2 + "error :vlist within vlist";
            }
            String string5 = "vlist(" + string4 + ")";
            String string6 = string4;
            string = MathView.replace(string, string5, string6);
            n = string.indexOf("vlist(");
        }
        string = MathView.replace(string, ",", " and ");
        return string;
    }

    private String root2sqrtn(String string) {
        int n = string.indexOf("root(");
        if (n == -1) {
            return string;
        }
        String string2 = string;
        int n2 = 0;
        while (n >= 0) {
            if (++n2 > 1000) {
                return string2 + " root(a,b) syntax error";
            }
            int n3 = string.length();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int i = n + 4; i < n3; ++i) {
                if (n6 != 0) continue;
                char c = string.charAt(i);
                if (c == '(') {
                    ++n4;
                }
                if (c == ')') {
                    ++n5;
                }
                if (n5 == 0 || n4 != n5) continue;
                n6 = i;
            }
            String string3 = string.substring(n + 5, n6);
            int n7 = string3.indexOf(",");
            if (n7 < 0) {
                return string2 + " syntax error: comma missing\nroot(a,b)";
            }
            int n8 = string3.length();
            String string4 = string3.substring(0, n7);
            String string5 = string3.substring(n7 + 1, n8);
            if (string4.indexOf("root(") != -1) {
                return string2 + "error : absurd root-syntax";
            }
            if (string5.indexOf("root(") != -1) {
                return string2 + "error : absurd root-syntax";
            }
            String string6 = "root(" + string4 + "," + string5 + ")";
            String string7 = "sqrt[" + string5 + "]#" + string4 + "@";
            string = MathView.replace(string, string6, string7);
            n = string.indexOf("root(");
        }
        string = string.replace('#', '(');
        string = string.replace('@', ')');
        return string;
    }

    private String sqrtn2root(String string) {
        int n = string.indexOf("sqrt[");
        if (n == -1) {
            return string;
        }
        String string2 = string;
        int n2 = 0;
        while (n >= 0) {
            char c;
            int n3;
            if (++n2 > 1000) {
                return string2 + "sqrt[]() syntax error";
            }
            int n4 = string.length();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            for (n3 = n + 4; n3 < n4; ++n3) {
                if (n7 != 0) continue;
                c = string.charAt(n3);
                if (c == '[') {
                    ++n5;
                }
                if (c == ']') {
                    ++n6;
                }
                if (n6 == 0 || n5 != n6) continue;
                n7 = n3;
            }
            int n8 = n7;
            String string3 = string.substring(n + 5, n7);
            n5 = 0;
            n6 = 0;
            n7 = 0;
            for (n3 = n8; n3 < n4; ++n3) {
                if (n7 != 0) continue;
                c = string.charAt(n3);
                if (c == '(') {
                    ++n5;
                }
                if (c == ')') {
                    ++n6;
                }
                if (n6 == 0 || n5 != n6) continue;
                n7 = n3;
            }
            String string4 = string.substring(n8 + 2, n7);
            String string5 = "root#" + string4 + "," + string3 + "@";
            String string6 = "sqrt[" + string3 + "](" + string4 + ")";
            string = MathView.replace(string, string6, string5);
            n = string.indexOf("sqrt[");
        }
        string = string.replace('#', '(');
        string = string.replace('@', ')');
        return string;
    }

    private String filter1(String string, int n) {
        String[] stringArray = new String[]{"of", "et", "en", "*", "cdot", "times", "div", "N", "Z", "Q", "R", "\\", "f^-1(x)", "isin", "and", "or", "notin", "-->", "=>", "inf", "->", "~", "log[2]", "log[3]", "log[4]", "log[5]", "log[6]", "log[7]", "log[8]", "log[9]"};
        String[] stringArray2 = new String[]{"\u22c1", "\u22c0", "\u22c0", "\u2027", "\u2027", "X", "\u00f7", "\u2115", "\u2124", "\u211a", "\u211d", "\u2216", "f\u00af\u00b9(x)", "\u2208", "\u22c0", "\u22c1", "\u2209", "rightarrow", "\u21d4", "\u221e", "\u2192", "\u2248", "\u00b2log", "\u00b3log", "\u2074log", "\u2075log", "\u2076log", "\u2077log", "\u2078log", "\u2079log"};
        String[] stringArray3 = new String[]{" or ", " and ", " and ", "*", "*", "*", "/", "N", "Z", "Q", "R", "\\", "f^-1(x)", " isin ", " and ", " or ", " notin ", " -> ", " -> ", " inf ", " -> ", " ~ ", "log[2]", "log[3]", "log[4]", "log[5]", "log[6]", "log[7]", "log[8]", "log[9]"};
        int n2 = stringArray.length;
        if (n == 1) {
            for (int i = 0; i < n2; ++i) {
                String string2 = stringArray[i];
                String string3 = stringArray2[i];
                string = MathView.replace(string, string2, string3);
            }
            string = this.sqrtn2root(string);
        } else {
            for (int i = 0; i < n2; ++i) {
                String string4 = stringArray3[i];
                String string5 = stringArray2[i];
                string = MathView.replace(string, string5, string4);
            }
        }
        return string;
    }

    private String filter2(String string) {
        String string2;
        if (this.Special_Fraction) {
            string = MathView.replace(string, " ", "+");
        }
        if ((string2 = this.readParams("wimsvars")).length() == 0) {
            string2 = "x";
        }
        string2 = string2.toString();
        string2 = MathView.replace(string2, ",", "");
        StringBuffer stringBuffer = new StringBuffer(string);
        String string3 = "";
        String string4 = "0123456789" + string2;
        string4 = string4.toString();
        int n = string2.length();
        int n2 = string4.length();
        int n3 = stringBuffer.length();
        String[] stringArray = new String[]{"sq", "si", "co", "ta", "ab", "lo", "ln"};
        int n4 = 7;
        String string5 = "";
        int n5 = this.linearInput.getCaretPosition();
        if (n3 > 1) {
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                for (int j = 0; j < n2; ++j) {
                    char c2;
                    char c3;
                    int n6;
                    char c4 = string4.charAt(j);
                    for (n6 = 0; n6 < n3 - 1; ++n6) {
                        c3 = stringBuffer.charAt(n6);
                        c2 = stringBuffer.charAt(n6 + 1);
                        if (c3 != c4 || c2 != c) continue;
                        stringBuffer = stringBuffer.insert(n6 + 1, "*");
                        ++n3;
                        this.linearInput.setText(stringBuffer.toString());
                        ++n5;
                    }
                    n3 = stringBuffer.length();
                    if (n3 <= 3) continue;
                    for (n6 = 0; n6 < n3 - 2; ++n6) {
                        c3 = stringBuffer.charAt(n6);
                        c2 = stringBuffer.charAt(n6 + 1);
                        char c5 = stringBuffer.charAt(n6 + 2);
                        if (c3 == ' ' && c2 == ' ' && c5 == ' ' || c3 == ' ' && c2 == 'e' && c5 == 'n' || c3 == 'e' && c2 == 'n' && c5 == ' ' || c3 == 'e' && c2 == 'n' && c5 == c) {
                            stringBuffer = stringBuffer.delete(n6, n6 + 3);
                            stringBuffer = stringBuffer.append(" and ");
                            n6 += 3;
                            this.linearInput.setText(stringBuffer.toString());
                        } else if (c3 == ' ' && c2 == 'o' && c5 == 'f' || c3 == 'o' && c2 == 'f' && c5 == ' ' || c3 == 'o' && c2 == 'f' && c5 == c) {
                            stringBuffer = stringBuffer.delete(n6, n6 + 3);
                            stringBuffer = stringBuffer.append(" or ");
                            n6 += 2;
                            ++n5;
                            this.linearInput.setText(stringBuffer.toString());
                        } else if (c3 == c4 || c3 == c) {
                            string3 = "" + c2 + c5;
                            for (int k = 0; k < n4; ++k) {
                                string5 = stringArray[k];
                                if (!string3.equals(string5)) continue;
                                stringBuffer = stringBuffer.insert(n6 + 1, "*");
                                k = n4;
                                n6 += 4;
                                ++n5;
                                this.linearInput.setText(stringBuffer.toString());
                            }
                        }
                        n3 = stringBuffer.length();
                    }
                }
            }
        }
        this.linearInput.setCaretPosition(n5);
        this.linearInput.requestFocus();
        string = stringBuffer.toString();
        string = this.sqrtn2root(string);
        return string;
    }

    private String readParams(String string) {
        String string2 = this.getParameter(string);
        return string2;
    }

    private void reportError(String string) {
        if (!this.inAnApplet) {
            System.err.println(string);
        }
    }

    private void addPaletteCard(Choice choice, Container container, String string, Container container2) {
        choice.add(string);
        container.add((Component)container2, string);
    }

    private JButton addButton(Container container, String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        container.add(jButton);
        return jButton;
    }

    private JButton addButton(Container container, String string, String string2, String string3) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        container.add((Component)jButton, string3);
        return jButton;
    }

    public void start() {
        this.linearInput.setFont(this.defaultFont);
        this.linearInput.invalidate();
        this.j.invalidate();
        this.repaint();
        this.linearInput.requestFocus();
        String string = this.readParams("oldreply");
        if (string.length() != 0) {
            string = MathView.replace(string, " ", "");
            string = this.filter1(string, 1);
            this.linearInput.setText(string.toString());
        }
    }

    public void init() {
        Object object;
        Object object2;
        Object object3;
        JPanel jPanel;
        Object object4;
        String string;
        try {
            string = this.readParams("special_fraction");
            if (string.equalsIgnoreCase("yes") || string.equals("1")) {
                this.Special_Fraction = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = this.readParams("my_panel");
        String string2 = this.readParams("smallfont");
        String string3 = this.readParams("largefont");
        int n = string2 == null ? 16 : Integer.parseInt(string2);
        int n2 = string3 == null ? 24 : Integer.parseInt(string3);
        this.bigFont = new Font("Helvetica", 0, n2);
        this.defaultFont = new Font("Helvetica", 0, n);
        String string4 = this.readParams("bgcolor");
        Color color = new Color(0xFFFFFF);
        if (string4 != null) {
            try {
                color = Color.decode(string4);
            }
            catch (Exception exception) {
                System.out.println("do't know color " + string4);
            }
        }
        this.setBackground(color);
        this.j = new Jome();
        this.j.setFont(this.defaultFont);
        this.j.setDrawBounds(true);
        this.j.setBackground(color);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(new BorderLayout());
        this.controlPane = new JPanel();
        this.controlPane.setFont(this.defaultFont);
        this.controlPane.setLayout(new BorderLayout());
        this.palette = new JPanel();
        this.palette.setLayout(new BorderLayout());
        this.palette.setFont(this.defaultFont);
        this.paletteCards = new JPanel();
        this.paletteCardsLayout = new CardLayout(5, 4);
        this.paletteCards.setLayout(this.paletteCardsLayout);
        this.paletteChoice = new Choice();
        this.paletteChoice.addItemListener(this);
        if (string != null) {
            int n3 = 7;
            object4 = string.split(":");
            jPanel = new JPanel();
            jPanel.setLayout(new GridLayout());
            int n4 = ((String[])object4).length;
            object3 = "";
            object2 = object4[0];
            for (int i = 1; i < n4; ++i) {
                object = object4[i];
                if (((String)object).equals("~")) {
                    object3 = "\u2248";
                } else if (((String)object).equals("sqrt()")) {
                    object3 = "\u221a";
                } else if (((String)object).equals("sqrt[2]()")) {
                    object = "sqrt()";
                    object3 = "<html><sup>2</sup>\u221a</html>";
                } else if (((String)object).equals("sqrt[3]()")) {
                    object3 = "<html><sup>3</sup>\u221a</font></html>";
                } else if (((String)object).equals("sqrt[4]()")) {
                    object3 = "<html><sup>4</sup>\u221a</html>";
                } else if (((String)object).equals("sqrt[5]()")) {
                    object3 = "<html><sup>5</sup>\u221a</html>";
                } else if (((String)object).equals("sqrt[6]()")) {
                    object3 = "<html><sup>6</sup>\u221a</html>";
                } else if (((String)object).equals("sqrt[7]()")) {
                    object3 = "<html><sup>7</sup>\u221a</html>";
                } else if (((String)object).equals("sqrt[8]()")) {
                    object3 = "<html><sup>8</sup>\u221a</html>";
                } else if (((String)object).equals("sqrt[9]()")) {
                    object3 = "<html><sup>9</sup>\u221a</html>";
                } else if (((String)object).equals("sqrt[n]()")) {
                    object3 = "<html><sup>n</sup>\u221a</html>";
                } else if (((String)object).equals("log[2]()")) {
                    object = "\u00b2log()";
                    object3 = "<html><sup>2</sup>log</html>";
                } else if (((String)object).equals("log[3]()")) {
                    object = "\u00b3log()";
                    object3 = "<html><sup>3</sup>log</html>";
                } else if (((String)object).equals("log[4]()")) {
                    object = "\u2074log()";
                    object3 = "<html><sup>4</sup>log</html>";
                } else if (((String)object).equals("log[5]()")) {
                    object = "\u2075log()";
                    object3 = "<html><sup>5</sup>log</html>";
                } else if (((String)object).equals("log[6]()")) {
                    object = "\u2076log()";
                    object3 = "<html><sup>6</sup>log</html>";
                } else if (((String)object).equals("log[7]()")) {
                    object = "\u2077log()";
                    object3 = "<html><sup>7</sup>log</html>";
                } else if (((String)object).equals("log[8]()")) {
                    object = "\u2078log()";
                    object3 = "<html><sup>8</sup>log</html>";
                } else if (((String)object).equals("log[9]()")) {
                    object = "\u2079log()";
                    object3 = "<html><sup>9</sup>log</html>";
                } else if (((String)object).equals("isin")) {
                    object = " in ";
                    object3 = "\u2208 [isin]";
                } else if (((String)object).equals("and")) {
                    object = " and ";
                    object3 = "\u22c0 [and]";
                } else if (((String)object).equals("or")) {
                    object = " or ";
                    object3 = "\u22c1 [or]";
                } else if (((String)object).equals("pi")) {
                    object = " pi ";
                    object3 = "\u03c0";
                } else if (((String)object).equals("notin")) {
                    object = " notin ";
                    object3 = "\u2209 [notin]";
                } else if (((String)object).equals("->")) {
                    object = "\u2192";
                    object3 = "\u2192";
                } else if (((String)object).equals("=>")) {
                    object3 = object = "\u2192";
                } else if (((String)object).equals("<=>")) {
                    object3 = object = "\u21e4";
                } else if (((String)object).equals("<->")) {
                    object3 = object = "\u21d4";
                } else if (((String)object).equals("<->")) {
                    object3 = object = "\u21d4";
                } else if (((String)object).equals("langle")) {
                    object = " langle ";
                    object3 = "<";
                } else if (((String)object).equals("rangle")) {
                    object = " rangle ";
                    object3 = ">";
                } else if (((String)object).equals("lbracket")) {
                    object = " lbracket ";
                    object3 = "[";
                } else if (((String)object).equals("rbracket")) {
                    object = " rbracket ";
                    object3 = "]";
                } else if (((String)object).equals("inf")) {
                    object = "infty";
                    object3 = "\u221e";
                } else {
                    object3 = object;
                }
                this.addButton(jPanel, (String)object3, "insert " + (String)object);
            }
            this.addPaletteCard(this.paletteChoice, this.paletteCards, (String)object2, jPanel);
            this.palette.add((Component)this.paletteChoice, "North");
            this.palette.add((Component)this.paletteCards, "Center");
            this.controlPane.add((Component)this.palette, "Center");
            this.j.setVisible(true);
            this.add((Component)this.j, "Center");
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this.addButton(jPanel2, "\u22c0 [and]", "insert  and ");
        this.addButton(jPanel2, "\u22c1 [or]", "insert  or ");
        this.addButton(jPanel2, "\u2208 [in]", "insert  in");
        this.addButton(jPanel2, "\u2209 [notin]", "insert  notin");
        this.addButton(jPanel2, "\u2192", "insert  \u2192 ");
        this.addButton(jPanel2, "\u21d4", "insert \u21d4");
        this.addButton(jPanel2, "\u221e [inf]", "insert \u221e");
        this.addPaletteCard(this.paletteChoice, this.paletteCards, "Misc. Symbols", jPanel2);
        this.palette.add((Component)this.paletteChoice, "North");
        this.palette.add((Component)this.paletteCards, "Center");
        this.controlPane.add((Component)this.palette, "Center");
        this.j.setVisible(true);
        this.add((Component)this.j, "Center");
        object4 = new JPanel();
        ((Container)object4).setLayout(new GridLayout());
        this.addButton((Container)object4, "multiple answers", "insert vlist(answer1,answer2,answer3,answer4)");
        this.addButton((Container)object4, "ln", "append ln()");
        this.addButton((Container)object4, "|x|", "append |x|");
        this.addButton((Container)object4, "f \u00af\u00b9(x)= [inverse]", "append f\u00af\u00b9(x)=");
        this.addPaletteCard(this.paletteChoice, this.paletteCards, "Misc.", (Container)object4);
        this.palette.add((Component)this.paletteChoice, "North");
        this.palette.add((Component)this.paletteCards, "Center");
        this.controlPane.add((Component)this.palette, "Center");
        this.j.setVisible(true);
        this.add((Component)this.j, "Center");
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.addButton(jPanel, "log", "append log()");
        this.addButton(jPanel, "<html><sup>2</sup>log</html>", "append \u00b2log()");
        this.addButton(jPanel, "<html><sup>3</sup>log</html>", "append \u00b3log()");
        this.addButton(jPanel, "<html><sup>4</sup>log</html>", "append \u2074log()");
        this.addButton(jPanel, "<html><sup>5</sup>log</html>", "append \u2075log()");
        this.addButton(jPanel, "<html><sup>6</sup>log</html>", "append \u2076log()");
        this.addButton(jPanel, "<html><sup>7</sup>log</html>", "append \u2077log()");
        this.addButton(jPanel, "<html><sup>8</sup>log</html>", "append \u2078log()");
        this.addButton(jPanel, "<html><sup>9</sup>log</html>", "append \u2079log()");
        this.addPaletteCard(this.paletteChoice, this.paletteCards, "Log", jPanel);
        this.palette.add((Component)this.paletteChoice, "North");
        this.palette.add((Component)this.paletteCards, "Center");
        this.controlPane.add((Component)this.palette, "Center");
        this.j.setVisible(true);
        this.add((Component)this.j, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout());
        this.addButton(jPanel3, "\u221a", "append sqrt()");
        this.addButton(jPanel3, "<html><sup>3</sup>\u221a</html>", "append sqrt[3]()");
        this.addButton(jPanel3, "<html><sup>4</sup>\u221a</html>", "append sqrt[4]()");
        this.addButton(jPanel3, "<html><sup>5</sup>\u221a</html>", "append sqrt[5]()");
        this.addButton(jPanel3, "<html><sup>6</sup>\u221a</html>", "append sqrt[6]()");
        this.addButton(jPanel3, "<html><sup>7</sup>\u221a</html>", "append sqrt[7]()");
        this.addButton(jPanel3, "<html><sup>8</sup>\u221a</html>", "append sqrt[8]()");
        this.addButton(jPanel3, "<html><sup>n</sup>\u221a</html>", "append sqrt[n](p)");
        this.addPaletteCard(this.paletteChoice, this.paletteCards, "\u221a", jPanel3);
        this.palette.add((Component)this.paletteChoice, "North");
        this.palette.add((Component)this.paletteCards, "Center");
        this.controlPane.add((Component)this.palette, "Center");
        this.j.setVisible(true);
        this.add((Component)this.j, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout());
        this.addButton(jPanel4, "\u03c0 [pi]", "insert  pi ");
        this.addButton(jPanel4, "sin()", "append sin()");
        this.addButton(jPanel4, "sin\u00b2()", "append sin()^2");
        this.addButton(jPanel4, "cos()", "append cos()");
        this.addButton(jPanel4, "cos\u00b2()", "append cos()^2");
        this.addButton(jPanel4, "tan()", "append tan()");
        this.addButton(jPanel4, "tan\u00b2()", "append tan()^2");
        this.addPaletteCard(this.paletteChoice, this.paletteCards, "Trigonometry", jPanel4);
        this.palette.add((Component)this.paletteChoice, "North");
        this.palette.add((Component)this.paletteCards, "Center");
        this.controlPane.add((Component)this.palette, "Center");
        this.j.setVisible(true);
        this.add((Component)this.j, "Center");
        object = new JPanel();
        ((Container)object).setLayout(new GridLayout());
        this.addButton((Container)object, " < : > ", "append  langle : rangle");
        this.addButton((Container)object, " [ : > ", "append  lbracket : rangle");
        this.addButton((Container)object, " < : ] ", "append  langle : rbracket");
        this.addButton((Container)object, " [ : ] ", "append  lbracket : rbracket");
        this.addButton((Container)object, "-\u221e [-inf]", "insert -\u221e");
        this.addButton((Container)object, "+\u221e [+inf]", "insert +\u221e");
        this.addPaletteCard(this.paletteChoice, this.paletteCards, "Domains I", (Container)object);
        this.palette.add((Component)this.paletteChoice, "North");
        this.palette.add((Component)this.paletteCards, "Center");
        this.controlPane.add((Component)this.palette, "Center");
        this.j.setVisible(true);
        this.add((Component)this.j, "Center");
        object3 = new JPanel();
        ((Container)object3).setLayout(new GridLayout());
        this.addButton((Container)object3, "x \u2208 \u2115 \u2216 { a ; b }", "insert x\u2208\u2115 \u2216 {a:b:c}");
        this.addButton((Container)object3, "x \u2208 \u2124 \u2216 { a ; b }", "insert x\u2208\u2124 \u2216 {a:b:c}");
        this.addButton((Container)object3, "x \u2208 \u211a \u2216 { a ; b }", "insert x\u2208\u211a \u2216 {a:b:c}");
        this.addButton((Container)object3, "x \u2208 \u211d \u2216 { a ; b }", "insert x\u2208\u211d \u2216 {a:b:c}");
        this.addPaletteCard(this.paletteChoice, this.paletteCards, "Domains II", (Container)object3);
        this.palette.add((Component)this.paletteChoice, "North");
        this.palette.add((Component)this.paletteCards, "Center");
        this.controlPane.add((Component)this.palette, "Center");
        this.j.setVisible(true);
        this.add((Component)this.j, "Center");
        object2 = new JPanel();
        ((Container)object2).setLayout(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        ((Container)object2).add((Component)jPanel5, "South");
        this.reportError("OK");
        JPanel jPanel6 = new JPanel();
        ((Container)object2).add((Component)jPanel6, "West");
        this.undoButton = this.addButton(jPanel6, "\u21a9", "undo");
        this.redoButton = null;
        this.addButton(jPanel6, "\u00b1", "toggle_font", "Center");
        this.controlPane.add((Component)object2, "South");
        this.linearInput = new TextArea("", 1, 1, 3);
        this.linearInput.addTextListener(this);
        this.linearInput.setFont(this.bigFont);
        this.linearInput.setBackground(Color.white);
        this.controlPane.add((Component)this.linearInput, "North");
        this.add((Component)this.controlPane, "South");
        this.setVisible(true);
        this.setLinear("");
        this.linearInput.requestFocus();
    }

    private void setLinear(String string) {
        this.markUndo();
        this.linearInput.setText(string);
        this.updateJomeView();
    }

    private void markUndo() {
        if (this.redoButton != null) {
            this.undoBuffer[this.undoBufferCursor] = this.linearInput.getText();
            ++this.undoBufferCursor;
            if (this.undoBufferCursor >= this.undoBuffer.length) {
                this.undoBufferCursor = 0;
            }
            if (this.undoBufferValidSize < this.undoBuffer.length) {
                ++this.undoBufferValidSize;
                this.undoBufferValidSizeMax = this.undoBufferValidSize;
            }
            this.updateUndoRedoButtons();
        } else {
            this.previousLinear = this.linearInput.getText();
        }
    }

    private void redo() {
        if (this.undoBufferValidSize < this.undoBufferValidSizeMax) {
            ++this.undoBufferCursor;
            ++this.undoBufferValidSize;
            if (this.undoBufferCursor >= this.undoBuffer.length) {
                this.undoBufferCursor = 0;
            }
            this.linearInput.setText(this.undoBuffer[this.undoBufferCursor]);
        }
        this.updateUndoRedoButtons();
        this.updateJomeView();
    }

    private void undo() {
        if (this.redoButton != null) {
            if (this.undoBufferValidSize > 0) {
                --this.undoBufferValidSize;
                --this.undoBufferCursor;
                if (this.undoBufferCursor < 0) {
                    this.undoBufferCursor = this.undoBuffer.length - 1;
                }
                if (this.undoBuffer[this.undoBufferCursor] != null) {
                    this.linearInput.setText(this.undoBuffer[this.undoBufferCursor]);
                }
            }
            this.updateUndoRedoButtons();
        } else if (this.previousLinear != null) {
            String string = this.linearInput.getText();
            this.linearInput.setText(this.previousLinear);
            this.previousLinear = string;
        }
        this.updateJomeView();
    }

    private void updateUndoRedoButtons() {
        this.undoButton.setEnabled(this.undoBufferValidSize > 0);
        this.redoButton.setEnabled(this.undoBufferValidSize < this.undoBufferValidSizeMax);
    }

    private void updateJomeView() {
        String string = this.linearInput.getText().toString();
        string = this.filter2(string);
        String string2 = this.readParams("helptext");
        if (string2 != null || string2.length() > 1) {
            string2 = this.filter1(string2, 1);
            string = string2 + string;
            string = string.toString();
        }
        this.j.setLinear(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        String string = actionEvent.getActionCommand();
        if (string.startsWith("append ")) {
            this.markUndo();
            this.linearInput.setText(this.linearInput.getText() + string.substring("append ".length()));
            bl = true;
        } else if (string.startsWith("insert ")) {
            this.markUndo();
            String string2 = this.linearInput.getText();
            int n = this.linearInput.getCaretPosition();
            this.linearInput.setText(string2.substring(0, n) + string.substring("insert ".length()) + string2.substring(n));
            bl = true;
        } else if (string.startsWith("enclose ")) {
            this.markUndo();
            String string3 = this.linearInput.getText();
            String string4 = string.substring("append ".length(), string.length() - 1);
            String string5 = string.substring(string.length() - 1);
            int n = this.linearInput.getSelectionStart();
            int n2 = this.linearInput.getSelectionEnd();
            this.linearInput.setText(string3.substring(0, n) + string4 + this.linearInput.getSelectedText() + string5 + string3.substring(n2));
            bl = true;
        } else if (string.equals("undo")) {
            this.undo();
        } else if (string.equals("redo")) {
            this.redo();
        } else if (string.equals("toggle_font")) {
            this.toggleFont();
        } else {
            this.updateJomeView();
        }
        if (bl) {
            this.linearInput.setCaretPosition(this.linearInput.getText().length());
            this.linearInput.requestFocus();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.paletteCardsLayout.show(this.paletteCards, (String)itemEvent.getItem());
        this.linearInput.requestFocus();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.updateJomeView();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowResized(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.stop();
        this.destroy();
        if (!this.inAnApplet) {
            this.standaloneWindow.setVisible(false);
            this.standaloneWindow.dispose();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public String getLinear() {
        int n;
        String string = this.j.getLinear();
        String string2 = this.readParams("helptext");
        if (string2 != null && (n = (string2 = this.filter1(string2, 1)).length()) > 0) {
            int n2 = string.length();
            string = string.substring(n, n2);
        }
        string = this.filter1(string, 0);
        string = this.root2sqrtn(string);
        string = this.removespecial(string);
        return string;
    }
}

